package ru.yandex.intranet.d.web.model.loans

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonFormat
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import io.swagger.v3.oas.annotations.media.Schema
import ru.yandex.intranet.d.kotlin.ResourceId
import ru.yandex.intranet.d.model.loans.LoanAmount
import java.math.BigInteger

@JsonIgnoreProperties(ignoreUnknown = true)
@Schema(description = "Loan amount")
data class LoanAmountDto @JsonCreator constructor(
    @get:Schema(description = "Resource ID", nullable = false)
    val resource: ResourceId,

    @JsonFormat(shape = JsonFormat.Shape.STRING)
    @get:Schema(description = "Amount big integer", nullable = false)
    val amount: BigInteger
) {
    constructor(model: LoanAmount) : this(
        resource = model.resource,
        amount = model.amount
    )
}
