package ru.yandex.intranet.d.web.model.loans

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import io.swagger.v3.oas.annotations.media.Schema
import ru.yandex.intranet.d.model.loans.LoanAmounts

@JsonIgnoreProperties(ignoreUnknown = true)
@Schema(description = "Loan amounts list")
data class LoanAmountsDto @JsonCreator constructor(
    @get:Schema(description = "Loan amounts list", nullable = false)
    val amounts: List<LoanAmountDto>
) {
    constructor(model: LoanAmounts) : this(
        amounts = model.amounts.map { LoanAmountDto(it) }
    )
}
