package ru.yandex.intranet.d.web.model.loans

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonValue
import ru.yandex.intranet.d.model.loans.LoanStatus

enum class LoanDirection {

    // Service will receive payments on these loans.
    IN,

    // Service will send payments on these loans.
    OUT;

    @JsonValue
    fun toJsonValue(): String {
        return name
    }

    companion object {
        @JsonCreator
        @JvmStatic
        fun fromJsonValue(value: String?): LoanStatus? {
            if (value == null) {
                return null
            }
            return LoanStatus.valueOf(value)
        }
    }
}
