package ru.yandex.intranet.d.web.model.loans

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonFormat
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import io.swagger.v3.oas.annotations.media.Schema
import ru.yandex.intranet.d.model.loans.LoanDueDate
import java.time.LocalDate
import java.time.ZoneId

@JsonIgnoreProperties(ignoreUnknown = true)
@Schema(description = "Lan due at date with timezone")
data class LoanDueDateDto @JsonCreator constructor(
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd")
    @get:Schema(description = "Local date", nullable = false)
    val localDate: LocalDate,

    @get:Schema(description = "Time zone ID", nullable = false)
    val timeZone: ZoneId
) {
    constructor(model: LoanDueDate) : this(
        localDate = model.localDate,
        timeZone = model.timeZone
    )
}
