package ru.yandex.intranet.d.web.model.loans

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import io.swagger.v3.oas.annotations.media.Schema
import ru.yandex.intranet.d.kotlin.AccountId
import ru.yandex.intranet.d.kotlin.FolderId
import ru.yandex.intranet.d.kotlin.ProviderId
import ru.yandex.intranet.d.kotlin.ServiceId
import ru.yandex.intranet.d.model.loans.LoanSubject
import ru.yandex.intranet.d.model.loans.LoanSubjectType

@JsonIgnoreProperties(ignoreUnknown = true)
data class LoanSubjectDto @JsonCreator constructor(
    @get:Schema(description = "Subject type, determines which fields are defined", nullable = false)
    val type: LoanSubjectType,

    @get:Schema(description = "Service ID", nullable = false)
    val service: ServiceId,

    @get:Schema(
        description = "Reserve service is defined for service reserve accounts only" +
            "It is different from the service only if reserve account is linked to the different service",
        nullable = true
    )
    val reserveService: ServiceId?,

    @get:Schema(
        description = "Account may be undefined, e.g. when materializing a provision out of the thin air " +
            "or destroying a provision." + "Also, when loan mey be paid off to any account in the selected service",
        nullable = true
    )
    val account: AccountId?,

    @get:Schema(description = "Folder for the account", nullable = true)
    val folder: FolderId?,

    @get:Schema(description = "Provider is defined only for provider reserve accounts", nullable = true)
    val provider: ProviderId?,
) {
    constructor(model: LoanSubject) : this(
        type = model.type,
        service = model.service,
        reserveService = model.reserveService,
        account = model.account,
        folder = model.folder,
        provider = model.provider
    )
}
