package ru.yandex.intranet.d.web.model.loans

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import io.swagger.v3.oas.annotations.media.Schema
import ru.yandex.intranet.d.model.loans.LoanStatus
import ru.yandex.intranet.d.model.loans.LoansHistoryFields

@Schema(description = "Loans history fields DTO")
@JsonIgnoreProperties(ignoreUnknown = true)
data class LoansHistoryFieldsDto @JsonCreator constructor(
    @get:Schema(description = "Loan version", required = true)
    val version: Long,

    @get:Schema(description = "Loan status", required = false)
    val status: LoanStatus?,

    @get:Schema(description = "Loan is due at, local date and timezone", required = false)
    val dueAt: LoanDueDateDto?,

    @get:Schema(description = "Pay off source", required = false)
    val payOffFrom: LoanSubjectDto?,

    @get:Schema(description = "Pay off destination", required = false)
    val payOffTo: LoanSubjectDto?,

    @get:Schema(description = "Borrowed amounts", required = false)
    val borrowedAmounts: LoanAmountsDto?,

    @get:Schema(description = "Amount to pay off", required = false)
    val payOffAmounts: LoanAmountsDto?,

    @get:Schema(description = "Amount left to pay off", required = false)
    val dueAmounts: LoanAmountsDto?
) {
    constructor(model: LoansHistoryFields) : this(
        version = model.version,
        status = model.status,
        dueAt = model.dueAt?.let { LoanDueDateDto(it) },
        payOffFrom = model.payOffFrom?.let { LoanSubjectDto(it) },
        payOffTo = model.payOffTo?.let { LoanSubjectDto(it) },
        borrowedAmounts = model.borrowedAmounts?.let { LoanAmountsDto(it) },
        payOffAmounts = model.payOffAmounts?.let { LoanAmountsDto(it) },
        dueAmounts = model.dueAmounts?.let { LoanAmountsDto(it) }
    )
}
