package ru.yandex.intranet.d.web.model.loans.api

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import io.swagger.v3.oas.annotations.media.Schema

@Schema(description = "Get loans history response DTO")
@JsonIgnoreProperties(ignoreUnknown = true)
data class ApiGetLoansHistoryResponseDto @JsonCreator constructor(
    @get:Schema(description = "Loans history events", required = true)
    val events: List<ApiLoansHistoryDto>,

    @get:Schema(description = "Next page token", required = false, nullable = true)
    val continuationToken: String?
)
