package ru.yandex.intranet.d.web.model.loans.api

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import io.swagger.v3.oas.annotations.media.Schema

@Schema(description = "Loans with dictionaries and next page token")
@JsonIgnoreProperties(ignoreUnknown = true)
data class ApiSearchLoansResponseDto @JsonCreator constructor(
    @get:Schema(description = "Loans", nullable = false)
    val loans: List<ApiLoanDto>,

    @get:Schema(description = "Next page token", nullable = true)
    val continuationToken: String?
)
