package ru.yandex.intranet.d.web.model.loans.history

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import io.swagger.v3.oas.annotations.media.Schema
import ru.yandex.intranet.d.kotlin.AccountId
import ru.yandex.intranet.d.kotlin.AccountsSpacesId
import ru.yandex.intranet.d.kotlin.FolderId
import ru.yandex.intranet.d.kotlin.ProviderId
import ru.yandex.intranet.d.kotlin.ResourceId
import ru.yandex.intranet.d.kotlin.ResourceTypeId
import ru.yandex.intranet.d.kotlin.SegmentId
import ru.yandex.intranet.d.kotlin.SegmentationId
import ru.yandex.intranet.d.kotlin.ServiceId
import ru.yandex.intranet.d.kotlin.UserId
import ru.yandex.intranet.d.web.model.dictionaries.FrontAccountDictionaryElementDto
import ru.yandex.intranet.d.web.model.dictionaries.FrontAccountsSpaceDictionaryElementDto
import ru.yandex.intranet.d.web.model.dictionaries.FrontFolderDictionaryElementDto
import ru.yandex.intranet.d.web.model.dictionaries.FrontProviderDictionaryElementDto
import ru.yandex.intranet.d.web.model.dictionaries.FrontResourceDictionaryElementDto
import ru.yandex.intranet.d.web.model.dictionaries.FrontResourceSegmentDictionaryElementDto
import ru.yandex.intranet.d.web.model.dictionaries.FrontResourceSegmentationDictionaryElementDto
import ru.yandex.intranet.d.web.model.dictionaries.FrontResourceTypeDictionaryElementDto
import ru.yandex.intranet.d.web.model.dictionaries.FrontServiceDictionaryElementDto
import ru.yandex.intranet.d.web.model.dictionaries.FrontUserDictionaryElementDto
import ru.yandex.intranet.d.web.model.loans.front.FrontLoansHistoryDto

@Schema(description = "Get loans history response DTO")
@JsonIgnoreProperties(ignoreUnknown = true)
data class FrontGetLoansHistoryResponseDto @JsonCreator constructor(
    @get:Schema(description = "Loans history events", required = true)
    val events: List<FrontLoansHistoryDto>,

    @get:Schema(description = "Providers by IDs", required = true)
    val providers: Map<ProviderId, FrontProviderDictionaryElementDto>,

    @get:Schema(description = "Accounts by IDs", required = true)
    val accounts: Map<AccountId, FrontAccountDictionaryElementDto>,

    @get:Schema(description = "Services by IDs", required = true)
    val services: Map<ServiceId, FrontServiceDictionaryElementDto>,

    @get:Schema(description = "Folders by IDs", required = true)
    val folders: Map<FolderId, FrontFolderDictionaryElementDto>,

    @get:Schema(description = "Resources by IDs", required = true)
    val resources: Map<ResourceId, FrontResourceDictionaryElementDto>,

    @get:Schema(description = "Resource types by IDs", required = true)
    val resourceTypes: Map<ResourceTypeId, FrontResourceTypeDictionaryElementDto>,

    @get:Schema(description = "Accounts spaces by IDs", required = true)
    val accountsSpaces: Map<AccountsSpacesId, FrontAccountsSpaceDictionaryElementDto>,

    @get:Schema(description = "Resource segments by IDs", required = true)
    val segments: Map<SegmentId, FrontResourceSegmentDictionaryElementDto>,

    @get:Schema(description = "Resource segmentations by IDs", required = true)
    val segmentations: Map<SegmentationId, FrontResourceSegmentationDictionaryElementDto>,

    @get:Schema(description = "Users by IDs", required = true)
    val users: Map<UserId, FrontUserDictionaryElementDto>,

    @get:Schema(description = "Next page token", required = false, nullable = true)
    val continuationToken: String?
) {
    constructor(
        events: List<FrontLoansHistoryDto>,
        dependencies: FrontGetLoansHistoryResponseDependencies,
        continuationToken: String?
    ) : this(
        events = events,
        providers = dependencies.providers,
        accounts = dependencies.accounts,
        services = dependencies.services,
        folders = dependencies.folders,
        resources = dependencies.resources,
        resourceTypes = dependencies.resourceTypes,
        accountsSpaces = dependencies.accountsSpaces,
        segments = dependencies.segments,
        segmentations = dependencies.segmentations,
        users = dependencies.users,
        continuationToken = continuationToken
    )
}

data class FrontGetLoansHistoryResponseDependencies(
    val providers: Map<ProviderId, FrontProviderDictionaryElementDto>,
    val accounts: Map<AccountId, FrontAccountDictionaryElementDto>,
    val services: Map<ServiceId, FrontServiceDictionaryElementDto>,
    val folders: Map<FolderId, FrontFolderDictionaryElementDto>,
    val resources: Map<ResourceId, FrontResourceDictionaryElementDto>,
    val resourceTypes: Map<ResourceTypeId, FrontResourceTypeDictionaryElementDto>,
    val accountsSpaces: Map<AccountsSpacesId, FrontAccountsSpaceDictionaryElementDto>,
    val segments: Map<SegmentId, FrontResourceSegmentDictionaryElementDto>,
    val segmentations: Map<SegmentationId, FrontResourceSegmentationDictionaryElementDto>,
    val users: Map<UserId, FrontUserDictionaryElementDto>,
)
