package ru.yandex.intranet.d.web.model.loans.front

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import io.swagger.v3.oas.annotations.media.Schema
import ru.yandex.intranet.d.kotlin.LoanHistoryId
import ru.yandex.intranet.d.kotlin.LoanId
import ru.yandex.intranet.d.kotlin.TransferRequestId
import ru.yandex.intranet.d.model.loans.LoanEventType
import ru.yandex.intranet.d.model.loans.LoansHistoryModel
import ru.yandex.intranet.d.web.model.loans.LoanActionSubjectDto
import ru.yandex.intranet.d.web.model.loans.LoanActionSubjectsDto
import ru.yandex.intranet.d.web.model.loans.LoansHistoryFieldsDto
import java.time.Instant

@Schema(description = "Front loans history DTO")
@JsonIgnoreProperties(ignoreUnknown = true)
data class FrontLoansHistoryDto @JsonCreator constructor(
    @get:Schema(description = "Loan history ID", required = true)
    val historyId: LoanHistoryId,

    @get:Schema(description = "Loan ID", required = true)
    val loanId: LoanId,

    @get:Schema(description = "Event timestamp", required = true)
    val eventTimestamp: Instant,


    @get:Schema(description = "Event author", required = true)
    val eventAuthor: LoanActionSubjectDto,

    @get:Schema(description = "Event approved by", required = false)
    val eventApprovedBy: LoanActionSubjectsDto?,

    @get:Schema(description = "Event type", required = true)
    val eventType: LoanEventType,

    @get:Schema(description = "Matching request ID", required = true)
    val transferRequestId: TransferRequestId?,

    @get:Schema(description = "Old fields values", required = false)
    val oldFields: LoansHistoryFieldsDto?,

    @get:Schema(description = "New fields values", required = false)
    val newFields: LoansHistoryFieldsDto?
) {
    constructor(model: LoansHistoryModel) : this(
        historyId = model.key.id,
        loanId = model.key.loanId,
        eventTimestamp = model.key.eventTimestamp,
        eventAuthor = LoanActionSubjectDto(model.eventAuthor),
        eventApprovedBy = model.eventApprovedBy?.let { LoanActionSubjectsDto(it) },
        eventType = model.eventType,
        transferRequestId = model.transferRequestId,
        oldFields = model.oldFields?.let { LoansHistoryFieldsDto(it) },
        newFields = model.newFields?.let { LoansHistoryFieldsDto(it) }
    )
}
