package ru.yandex.intranet.d.web.model.loans.front

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import io.swagger.v3.oas.annotations.media.Schema
import ru.yandex.intranet.d.kotlin.ServiceId
import ru.yandex.intranet.d.model.loans.LoanStatus
import ru.yandex.intranet.d.web.model.loans.LoanDirection

@Schema(description = "Get loans request DTO")
@JsonIgnoreProperties(ignoreUnknown = true)
data class FrontSearchLoansRequestDto @JsonCreator constructor(
    @get:Schema(description = "Service ID", required = true)
    val serviceId: ServiceId?,

    @get:Schema(description = "Loans status. If null, loans with any status will be returned.", required = false)
    val status: LoanStatus?,

    @get:Schema(description = "Direction specifies whether IN or OUT loans to be returned", required = true)
    val direction: LoanDirection?,

    @get:Schema(description = "Next page token", required = false)
    val from: String?,

    @get:Schema(description = "Max amount of loans to be returned", required = false)
    val limit: Int?
)


