package ru.yandex.intranet.d.web.model.loans.front

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import io.swagger.v3.oas.annotations.media.Schema
import ru.yandex.intranet.d.kotlin.AccountId
import ru.yandex.intranet.d.kotlin.AccountsSpacesId
import ru.yandex.intranet.d.kotlin.FolderId
import ru.yandex.intranet.d.kotlin.ProviderId
import ru.yandex.intranet.d.kotlin.ResourceId
import ru.yandex.intranet.d.kotlin.ResourceTypeId
import ru.yandex.intranet.d.kotlin.SegmentId
import ru.yandex.intranet.d.kotlin.SegmentationId
import ru.yandex.intranet.d.kotlin.ServiceId
import ru.yandex.intranet.d.kotlin.UserId
import ru.yandex.intranet.d.web.model.dictionaries.FrontAccountDictionaryElementDto
import ru.yandex.intranet.d.web.model.dictionaries.FrontAccountsSpaceDictionaryElementDto
import ru.yandex.intranet.d.web.model.dictionaries.FrontFolderDictionaryElementDto
import ru.yandex.intranet.d.web.model.dictionaries.FrontProviderDictionaryElementDto
import ru.yandex.intranet.d.web.model.dictionaries.FrontResourceDictionaryElementDto
import ru.yandex.intranet.d.web.model.dictionaries.FrontResourceSegmentDictionaryElementDto
import ru.yandex.intranet.d.web.model.dictionaries.FrontResourceSegmentationDictionaryElementDto
import ru.yandex.intranet.d.web.model.dictionaries.FrontResourceTypeDictionaryElementDto
import ru.yandex.intranet.d.web.model.dictionaries.FrontServiceDictionaryElementDto
import ru.yandex.intranet.d.web.model.dictionaries.FrontUserDictionaryElementDto

@Schema(description = "Loans with dictionaries and next page token")
@JsonIgnoreProperties(ignoreUnknown = true)
data class FrontSearchLoansResponseDto @JsonCreator constructor(
    @get:Schema(description = "Loans", nullable = false)
    val loans: List<FrontLoanDto>,

    @get:Schema(description = "Providers by IDs", nullable = false)
    val providers: Map<ProviderId, FrontProviderDictionaryElementDto>,

    @get:Schema(description = "Accounts by IDs", nullable = false)
    val accounts: Map<AccountId, FrontAccountDictionaryElementDto>,

    @get:Schema(description = "Services by IDs", required = true, nullable = false)
    val services: Map<ServiceId, FrontServiceDictionaryElementDto>,

    @get:Schema(description = "Folders by IDs", nullable = false)
    val folders: Map<FolderId, FrontFolderDictionaryElementDto>,

    @get:Schema(description = "Resources by IDs", nullable = false)
    val resources: Map<ResourceId, FrontResourceDictionaryElementDto>,

    @get:Schema(description = "Resource types by IDs", nullable = false)
    val resourceTypes: Map<ResourceTypeId, FrontResourceTypeDictionaryElementDto>,

    @get:Schema(description = "Accounts spaces by IDs", nullable = false)
    val accountsSpaces: Map<AccountsSpacesId, FrontAccountsSpaceDictionaryElementDto>,

    @get:Schema(description = "Resource segments by IDs", nullable = false)
    val segments: Map<SegmentId, FrontResourceSegmentDictionaryElementDto>,

    @get:Schema(description = "Resource segmentations by IDs", nullable = false)
    val segmentations: Map<SegmentationId, FrontResourceSegmentationDictionaryElementDto>,

    @get:Schema(description = "Users by IDs", nullable = false)
    val users: Map<UserId, FrontUserDictionaryElementDto>,

    @get:Schema(description = "Next page token", nullable = true)
    val continuationToken: String?
) {
    constructor(
        loans: List<FrontLoanDto>,
        dependencies: FrontSearchLoansResponseDependencies,
        continuationToken: String?
    ) : this(
        loans = loans,
        providers = dependencies.providers,
        accounts = dependencies.accounts,
        services = dependencies.services,
        folders = dependencies.folders,
        resources = dependencies.resources,
        resourceTypes = dependencies.resourceTypes,
        accountsSpaces = dependencies.accountsSpaces,
        segments = dependencies.segments,
        segmentations = dependencies.segmentations,
        users = dependencies.users,
        continuationToken = continuationToken
    )
}

data class FrontSearchLoansResponseDependencies(
    val providers: Map<ProviderId, FrontProviderDictionaryElementDto>,
    val accounts: Map<AccountId, FrontAccountDictionaryElementDto>,
    val services: Map<ServiceId, FrontServiceDictionaryElementDto>,
    val folders: Map<FolderId, FrontFolderDictionaryElementDto>,
    val resources: Map<ResourceId, FrontResourceDictionaryElementDto>,
    val resourceTypes: Map<ResourceTypeId, FrontResourceTypeDictionaryElementDto>,
    val accountsSpaces: Map<AccountsSpacesId, FrontAccountsSpaceDictionaryElementDto>,
    val segments: Map<SegmentId, FrontResourceSegmentDictionaryElementDto>,
    val segmentations: Map<SegmentationId, FrontResourceSegmentationDictionaryElementDto>,
    val users: Map<UserId, FrontUserDictionaryElementDto>,
)
