package ru.yandex.intranet.d.web.model.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;

/**
 * Operation status DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Operation status.")
public enum OperationStatusDto {

    IN_PROGRESS,
    SUCCESS,
    FAILURE;

    @JsonValue
    public String toJsonValue() {
        return name();
    }

    @JsonCreator
    public static OperationStatusDto fromJsonValue(String value) {
        return OperationStatusDto.valueOf(value);
    }

}
