package ru.yandex.intranet.d.web.model.providers

import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import com.fasterxml.jackson.annotation.JsonInclude
import io.swagger.v3.oas.annotations.media.Schema

/**
 * Aggregation algorithm DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Aggregation algorithm.")
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
data class AggregationAlgorithmDto(
    @get:Schema(description = "'Aggregation disabled' flag.", required = true)
    val disabled: Boolean,
    @get:Schema(description = "Upsert page size.", required = true)
    val upsertPageSize: Long,
    @get:Schema(description = "Quota query type.", required = true)
    val quotaQueryType: AggregationQuotaQueryTypeDto,
    @get:Schema(description = "'Concurrent upsert of aggregates' flag.", required = true)
    val concurrentAggregatesUpsert: Boolean,
    @get:Schema(description = "'Concurrent aggregation' flag.", required = true)
    val concurrentAggregation: Boolean,
    @get:Schema(description = "Resources page size.", required = true)
    val resourcesPageSize: Long,
    @get:Schema(description = "'Paginate resources' flag.", required = true)
    val paginateResources: Boolean,
    @get:Schema(description = "'Concurrent cleanup' flag.", required = true)
    val concurrentCleanup: Boolean
)
