package ru.yandex.intranet.d.web.model.providers

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonValue
import io.swagger.v3.oas.annotations.media.Schema

/**
 * Aggregation quota query type input DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Quota query type for aggregation.")
enum class AggregationQuotaQueryTypeInputDto {
    UNKNOWN,
    SCAN_SNAPSHOT,
    PAGINATE;

    @JsonValue
    fun toJsonValue(): String {
        return name
    }

    companion object {
        @JsonCreator
        @JvmStatic
        fun fromJsonValue(value: String?): AggregationQuotaQueryTypeInputDto? {
            if (value == null) {
                return null
            }
            return try {
                valueOf(value)
            } catch (e: IllegalArgumentException) {
                UNKNOWN
            }
        }
    }
}
