package ru.yandex.intranet.d.web.model.providers

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import io.swagger.v3.oas.annotations.media.Schema

/**
 * Aggregation settings DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Aggregation settings.")
@JsonIgnoreProperties(ignoreUnknown = true)
data class AggregationSettingsDto @JsonCreator constructor(
    @get:Schema(description = "Potentially free provision amounts aggregation mode.", required = true)
    val freeProvisionMode: FreeProvisionAggregationModeDto,
    @get:Schema(description = "Usage mode.", required = true)
    val usageMode: UsageModeDto,
    @get:Schema(description = "Time series grid spacing, seconds.")
    val timeSeriesGridSpacingSeconds: Long?
)
