package ru.yandex.intranet.d.web.model.providers

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import io.swagger.v3.oas.annotations.media.Schema

/**
 * Aggregation settings input DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Aggregation settings.")
@JsonIgnoreProperties(ignoreUnknown = true)
data class AggregationSettingsInputDto @JsonCreator constructor(
    @get:Schema(description = "Potentially free provision amounts aggregation mode.", required = true)
    val freeProvisionMode: FreeProvisionAggregationModeInputDto?,
    @get:Schema(description = "Usage mode.", required = true)
    val usageMode: UsageModeInputDto?,
    @get:Schema(description = "Time series grid spacing, seconds.")
    val timeSeriesGridSpacingSeconds: Long?
)
