package ru.yandex.intranet.d.web.model.providers

import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import com.fasterxml.jackson.annotation.JsonInclude
import io.swagger.v3.oas.annotations.media.Schema
import ru.yandex.intranet.d.model.providers.ExternalAccountUrlTemplate

/**
 * ExternalAccountUrlTemplateDto.
 *
 * @author Evgenii Serov <evserov@yandex-team.ru>
 */
@Schema(description = "External account url template.")
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
data class ExternalAccountUrlTemplateDto(
    val segments: Map<String, Set<String>>?,
    val defaultTemplate: Boolean?,
    val urlTemplates: Map<String, String>?,
    val urlsForSegments: Boolean?
) {
    constructor(model: ExternalAccountUrlTemplate) : this(
        model.segments,
        model.defaultTemplate,
        model.urlTemplates,
        model.urlsForSegments
    )

    constructor(proto: ru.yandex.intranet.d.backend.service.proto.ProviderExternalAccountUrlTemplate) : this(
        proto.segmentsList.associateBy({it.segmentationKey}, {it.segmentKeyList.toSet()}),
        proto.defaultTemplate,
        proto.urlTemplatesList.associateBy({it.name}, {it.template}),
        proto.urlsForSegments
    )
}
