package ru.yandex.intranet.d.web.model.providers

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonValue
import io.swagger.v3.oas.annotations.media.Schema

/**
 * Potentially free provision amounts aggregation mode DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Potentially free provision amounts aggregation mode.")
enum class FreeProvisionAggregationModeDto {
    NONE,
    UNALLOCATED_TRANSFERABLE,
    UNALLOCATED_TRANSFERABLE_UNUSED_DEALLOCATABLE,
    UNDERUTILIZED_TRANSFERABLE;

    @JsonValue
    fun toJsonValue(): String {
        return name
    }

    companion object {
        @JsonCreator
        @JvmStatic
        fun fromJsonValue(value: String?): FreeProvisionAggregationModeDto? {
            if (value == null) {
                return null
            }
            return valueOf(value)
        }
    }
}
