package ru.yandex.intranet.d.web.model.providers

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import io.swagger.v3.oas.annotations.media.Schema
import ru.yandex.intranet.d.kotlin.ProviderId

@Schema(description = "Providers list for resources exchange.")
@JsonIgnoreProperties(ignoreUnknown = true)
data class FrontGetProvidersForExchangeResponseDto @JsonCreator constructor(
    @get:Schema(description = "Providers.", required = true)
    val providers: Map<ProviderId, ProviderDto>
)
