package ru.yandex.intranet.d.web.model.providers;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.v3.oas.annotations.media.Schema;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;

import ru.yandex.intranet.d.web.model.FeatureStateDto;

/**
 * Full provider DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Provider.")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class FullProviderDto {

    private final String id;
    private final long version;
    private final String nameEn;
    private final String nameRu;
    private final String descriptionEn;
    private final String descriptionRu;
    private final String restApiUri;
    private final String grpcApiUri;
    private final long sourceTvmId;
    private final long destinationTvmId;
    private final long abcServiceId;
    private final boolean readOnly;
    private final boolean multipleAccountsPerFolder;
    private final boolean accountTransferWithQuota;
    private final boolean managed;
    private final String key;
    private final boolean accountsDisplayNameSupported;
    private final boolean accountsKeySupported;
    private final boolean accountsDeleteSupported;
    private final boolean accountsSoftDeleteSupported;
    private final boolean accountsMoveSupported;
    private final boolean accountsRenameSupported;
    private final boolean importAllowed;
    private final boolean accountsSpacesSupported;
    private final boolean perAccountVersionSupported;
    private final boolean perProvisionVersionSupported;
    private final boolean perAccountLastUpdateSupported;
    private final boolean perProvisionLastUpdateSupported;
    private final boolean operationIdDeduplicationSupported;
    private final boolean syncCoolDownDisabled;
    private final boolean retryCoolDownDisabled;
    private final long accountsSyncPageSize;
    private final boolean syncEnabled;
    private final Boolean grpcTlsOn;
    private final String meteringKey;
    private final Map<String, RelatedResourceMappingDto> relatedResourcesByResourceId;
    private final long trackerComponentId;
    private final String reserveFolderId;
    private final boolean hasDefaultQuotas;
    private final boolean moveProvisionSupported;
    private final FeatureStateDto allocatedSupported;
    private final @Nullable AggregationSettingsDto aggregationSettings;
    private final @Nullable AggregationAlgorithmDto aggregationAlgorithm;
    private final @Nullable ProviderUISettingsDto uiSettings;
    private final List<ExternalAccountUrlTemplateDto> externalAccountUrlTemplates;
    private final FeatureStateDto multipleReservesAllowed;

    @JsonCreator
    @SuppressWarnings("ParameterNumber")
    public FullProviderDto(String id,
                           long version,
                           String nameEn,
                           String nameRu,
                           String descriptionEn,
                           String descriptionRu,
                           String restApiUri,
                           String grpcApiUri,
                           long sourceTvmId,
                           long destinationTvmId,
                           long abcServiceId,
                           boolean readOnly,
                           boolean multipleAccountsPerFolder,
                           boolean accountTransferWithQuota,
                           boolean managed,
                           String key,
                           boolean accountsDisplayNameSupported,
                           boolean accountsKeySupported,
                           boolean accountsDeleteSupported,
                           boolean accountsSoftDeleteSupported,
                           boolean accountsMoveSupported,
                           boolean accountsRenameSupported,
                           boolean importAllowed,
                           boolean accountsSpacesSupported,
                           boolean perAccountVersionSupported,
                           boolean perProvisionVersionSupported,
                           boolean perAccountLastUpdateSupported,
                           boolean perProvisionLastUpdateSupported,
                           boolean operationIdDeduplicationSupported,
                           boolean syncCoolDownDisabled,
                           boolean retryCoolDownDisabled,
                           long accountsSyncPageSize,
                           boolean moveProvisionSupported,
                           boolean syncEnabled,
                           Boolean grpcTlsOn,
                           String meteringKey,
                           Map<String, RelatedResourceMappingDto> relatedResourcesByResourceId,
                           long trackerComponentId,
                           String reserveFolderId,
                           boolean hasDefaultQuotas,
                           FeatureStateDto allocatedSupported,
                           @Nullable AggregationSettingsDto aggregationSettings,
                           @Nullable AggregationAlgorithmDto aggregationAlgorithm,
                           @Nullable ProviderUISettingsDto uiSettings,
                           List<ExternalAccountUrlTemplateDto> externalAccountUrlTemplates,
                           FeatureStateDto multipleReservesAllowed
    ) {
        this.id = id;
        this.version = version;
        this.nameEn = nameEn;
        this.nameRu = nameRu;
        this.descriptionEn = descriptionEn;
        this.descriptionRu = descriptionRu;
        this.restApiUri = restApiUri;
        this.grpcApiUri = grpcApiUri;
        this.sourceTvmId = sourceTvmId;
        this.destinationTvmId = destinationTvmId;
        this.abcServiceId = abcServiceId;
        this.readOnly = readOnly;
        this.multipleAccountsPerFolder = multipleAccountsPerFolder;
        this.accountTransferWithQuota = accountTransferWithQuota;
        this.managed = managed;
        this.key = key;
        this.accountsDisplayNameSupported = accountsDisplayNameSupported;
        this.accountsKeySupported = accountsKeySupported;
        this.accountsDeleteSupported = accountsDeleteSupported;
        this.accountsSoftDeleteSupported = accountsSoftDeleteSupported;
        this.accountsMoveSupported = accountsMoveSupported;
        this.accountsRenameSupported = accountsRenameSupported;
        this.importAllowed = importAllowed;
        this.accountsSpacesSupported = accountsSpacesSupported;
        this.perAccountVersionSupported = perAccountVersionSupported;
        this.perProvisionVersionSupported = perProvisionVersionSupported;
        this.perAccountLastUpdateSupported = perAccountLastUpdateSupported;
        this.perProvisionLastUpdateSupported = perProvisionLastUpdateSupported;
        this.operationIdDeduplicationSupported = operationIdDeduplicationSupported;
        this.syncCoolDownDisabled = syncCoolDownDisabled;
        this.retryCoolDownDisabled = retryCoolDownDisabled;
        this.accountsSyncPageSize = accountsSyncPageSize;
        this.moveProvisionSupported = moveProvisionSupported;
        this.syncEnabled = syncEnabled;
        this.grpcTlsOn = grpcTlsOn;
        this.meteringKey = meteringKey;
        this.relatedResourcesByResourceId = relatedResourcesByResourceId;
        this.trackerComponentId = trackerComponentId;
        this.reserveFolderId = reserveFolderId;
        this.hasDefaultQuotas = hasDefaultQuotas;
        this.allocatedSupported = allocatedSupported;
        this.aggregationSettings = aggregationSettings;
        this.aggregationAlgorithm = aggregationAlgorithm;
        this.uiSettings = uiSettings;
        this.externalAccountUrlTemplates = externalAccountUrlTemplates;
        this.multipleReservesAllowed = multipleReservesAllowed;
    }

    @Schema(description = "Unique id.", required = true)
    public String getId() {
        return id;
    }

    @Schema(description = "Provider version.", required = true)
    public long getVersion() {
        return version;
    }

    @Schema(description = "Name english.", required = true)
    public String getNameEn() {
        return nameEn;
    }

    @Schema(description = "Name russian.", required = true)
    public String getNameRu() {
        return nameRu;
    }

    @Schema(description = "Description english.", required = true)
    public String getDescriptionEn() {
        return descriptionEn;
    }

    @Schema(description = "Description russian.", required = true)
    public String getDescriptionRu() {
        return descriptionRu;
    }

    @Schema(description = "REST API URI.")
    public Optional<String> getRestApiUri() {
        return Optional.ofNullable(restApiUri);
    }

    @Schema(description = "GRPC API URI.")
    public Optional<String> getGrpcApiUri() {
        return Optional.ofNullable(grpcApiUri);
    }

    @Schema(description = "Source TVM id.")
    public long getSourceTvmId() {
        return sourceTvmId;
    }

    @Schema(description = "Destination TVM id.")
    public long getDestinationTvmId() {
        return destinationTvmId;
    }

    @Schema(description = "ABC service id.", required = true)
    public long getAbcServiceId() {
        return abcServiceId;
    }

    @Schema(description = "'Read only' flag.", required = true)
    public boolean isReadOnly() {
        return readOnly;
    }

    @Schema(description = "'Multiple accounts per folder' flag.", required = true)
    public boolean isMultipleAccountsPerFolder() {
        return multipleAccountsPerFolder;
    }

    @Schema(description = "'Account transfer with quota' flag.", required = true)
    public boolean isAccountTransferWithQuota() {
        return accountTransferWithQuota;
    }

    @Schema(description = "'Managed' flag.", required = true)
    public boolean isManaged() {
        return managed;
    }

    @Schema(description = "Unique key.", required = true)
    public String getKey() {
        return key;
    }

    @Schema(description = "'Account display name is supported' flag.", required = true)
    public boolean isAccountsDisplayNameSupported() {
        return accountsDisplayNameSupported;
    }

    @Schema(description = "'Account key is supported' flag.", required = true)
    public boolean isAccountsKeySupported() {
        return accountsKeySupported;
    }

    @Schema(description = "'Account deletion is supported' flag.", required = true)
    public boolean isAccountsDeleteSupported() {
        return accountsDeleteSupported;
    }

    @Schema(description = "'Account soft-delete is supported' flag.", required = true)
    public boolean isAccountsSoftDeleteSupported() {
        return accountsSoftDeleteSupported;
    }

    @Schema(description = "'Account folder update is supported' flag.", required = true)
    public boolean isAccountsMoveSupported() {
        return accountsMoveSupported;
    }

    @Schema(description = "'Account rename is supported' flag.", required = true)
    public boolean isAccountsRenameSupported() {
        return accountsRenameSupported;
    }

    @Schema(description = "'Import is allowed' flag.", required = true)
    public boolean isImportAllowed() {
        return importAllowed;
    }

    @Schema(description = "'Accounts spaces are supported' flag", required = true)
    public boolean isAccountsSpacesSupported() {
        return accountsSpacesSupported;
    }

    @Schema(description = "'Per account version is supported' flag", required = true)
    public boolean isPerAccountVersionSupported() {
        return perAccountVersionSupported;
    }

    @Schema(description = "'Per provision version is supported' flag", required = true)
    public boolean isPerProvisionVersionSupported() {
        return perProvisionVersionSupported;
    }

    @Schema(description = "'Per account last update is supported' flag", required = true)
    public boolean isPerAccountLastUpdateSupported() {
        return perAccountLastUpdateSupported;
    }

    @Schema(description = "'Per provision last update is supported' flag", required = true)
    public boolean isPerProvisionLastUpdateSupported() {
        return perProvisionLastUpdateSupported;
    }

    @Schema(description = "'Operation id deduplication is supported' flag", required = true)
    public boolean isOperationIdDeduplicationSupported() {
        return operationIdDeduplicationSupported;
    }

    @Schema(description = "'Synchronization cool down is disabled' flag", required = true)
    public boolean isSyncCoolDownDisabled() {
        return syncCoolDownDisabled;
    }

    @Schema(description = "'Retries cool down is disabled' flag", required = true)
    public boolean isRetryCoolDownDisabled() {
        return retryCoolDownDisabled;
    }

    @Schema(description = "'Sync is enabled' flag", required = true)
    public boolean isSyncEnabled() {
        return syncEnabled;
    }

    @Schema(description = "'Use tls in grpc' flag", required = true)
    public boolean getGrpcTlsOn() {
        return grpcTlsOn;
    }

    @Schema(description = "Provider key in Metering.")
    public Optional<String> getMeteringKey() {
        return Optional.ofNullable(meteringKey);
    }

    @Schema(description = "Resource mapping to relative resources")
    public Optional<Map<String, RelatedResourceMappingDto>> getRelatedResourcesByResourceId() {
        return Optional.ofNullable(relatedResourcesByResourceId);
    }

    @Schema(description = "Provider component id in Tracker")
    public long getTrackerComponentId() {
        return trackerComponentId;
    }

    @Schema(description = "ID of provider's reserve folder, or null.")
    public String getReserveFolderId() {
        return reserveFolderId;
    }

    @Schema(description = "True, if provider has default quotas for some resources.", required = true)
    public boolean isHasDefaultQuotas() {
        return hasDefaultQuotas;
    }

    @Schema(description = "Maximum page size of accounts sync response.", required = true)
    public long getAccountsSyncPageSize() {
        return accountsSyncPageSize;
    }

    @Schema(description = "'MoveProvision method is supported' flag", required = true)
    public boolean isMoveProvisionSupported() {
        return moveProvisionSupported;
    }

    @Schema(description = "'Allocated supported' feature state", required = true)
    public FeatureStateDto getAllocatedSupported() {
        return allocatedSupported;
    }

    @Schema(description = "Aggregation settings.")
    public Optional<AggregationSettingsDto> getAggregationSettings() {
        return Optional.ofNullable(aggregationSettings);
    }

    @Schema(description = "Aggregation algorithm.")
    public Optional<AggregationAlgorithmDto> getAggregationAlgorithm() {
        return Optional.ofNullable(aggregationAlgorithm);
    }

    @Schema(description = "Providers UI settings.")
    public Optional<ProviderUISettingsDto> getUiSettings() {
        return Optional.ofNullable(uiSettings);
    }

    @Schema(description = "External account url templates")
    public Optional<List<ExternalAccountUrlTemplateDto>> getExternalAccountUrlTemplates() {
        return Optional.ofNullable(externalAccountUrlTemplates);
    }

    @Schema(description = "'Multiple reserves allowed' feature state", required = true)
    public FeatureStateDto getMultipleReservesAllowed() {
        return multipleReservesAllowed;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        FullProviderDto that = (FullProviderDto) o;
        return version == that.version &&
                sourceTvmId == that.sourceTvmId &&
                destinationTvmId == that.destinationTvmId &&
                abcServiceId == that.abcServiceId &&
                readOnly == that.readOnly &&
                multipleAccountsPerFolder == that.multipleAccountsPerFolder &&
                accountTransferWithQuota == that.accountTransferWithQuota &&
                managed == that.managed &&
                accountsDisplayNameSupported == that.accountsDisplayNameSupported &&
                accountsKeySupported == that.accountsKeySupported &&
                accountsDeleteSupported == that.accountsDeleteSupported &&
                accountsSoftDeleteSupported == that.accountsSoftDeleteSupported &&
                accountsMoveSupported == that.accountsMoveSupported &&
                accountsRenameSupported == that.accountsRenameSupported &&
                importAllowed == that.importAllowed &&
                accountsSpacesSupported == that.accountsSpacesSupported &&
                perAccountVersionSupported == that.perAccountVersionSupported &&
                perProvisionVersionSupported == that.perProvisionVersionSupported &&
                perAccountLastUpdateSupported == that.perAccountLastUpdateSupported &&
                perProvisionLastUpdateSupported == that.perProvisionLastUpdateSupported &&
                operationIdDeduplicationSupported == that.operationIdDeduplicationSupported &&
                syncCoolDownDisabled == that.syncCoolDownDisabled &&
                retryCoolDownDisabled == that.retryCoolDownDisabled &&
                syncEnabled == that.syncEnabled &&
                Objects.equals(id, that.id) &&
                Objects.equals(nameEn, that.nameEn) &&
                Objects.equals(nameRu, that.nameRu) &&
                Objects.equals(descriptionEn, that.descriptionEn) &&
                Objects.equals(descriptionRu, that.descriptionRu) &&
                Objects.equals(restApiUri, that.restApiUri) &&
                Objects.equals(grpcApiUri, that.grpcApiUri) &&
                Objects.equals(key, that.key) &&
                Objects.equals(grpcTlsOn, that.grpcTlsOn) &&
                Objects.equals(meteringKey, that.meteringKey) &&
                Objects.equals(relatedResourcesByResourceId, that.relatedResourcesByResourceId) &&
                trackerComponentId == that.trackerComponentId &&
                Objects.equals(reserveFolderId, that.reserveFolderId) &&
                hasDefaultQuotas == that.hasDefaultQuotas &&
                accountsSyncPageSize == that.accountsSyncPageSize &&
                moveProvisionSupported == that.moveProvisionSupported &&
                Objects.equals(allocatedSupported, that.allocatedSupported) &&
                Objects.equals(aggregationSettings, that.aggregationSettings) &&
                Objects.equals(aggregationAlgorithm, that.aggregationAlgorithm) &&
                Objects.equals(uiSettings, that.uiSettings) &&
                Objects.equals(externalAccountUrlTemplates, that.externalAccountUrlTemplates) &&
                Objects.equals(multipleReservesAllowed, that.multipleReservesAllowed);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, version, nameEn, nameRu, descriptionEn, descriptionRu, restApiUri, grpcApiUri,
                sourceTvmId, destinationTvmId, abcServiceId, readOnly, multipleAccountsPerFolder,
                accountTransferWithQuota, managed, key, accountsDisplayNameSupported, accountsKeySupported,
                accountsDeleteSupported, accountsSoftDeleteSupported, accountsMoveSupported, accountsRenameSupported,
                importAllowed, accountsSpacesSupported, perAccountVersionSupported, perProvisionVersionSupported,
                perAccountLastUpdateSupported, perProvisionLastUpdateSupported, operationIdDeduplicationSupported,
                syncCoolDownDisabled, retryCoolDownDisabled, syncEnabled, grpcTlsOn, meteringKey, accountsSyncPageSize,
                relatedResourcesByResourceId, trackerComponentId, reserveFolderId, hasDefaultQuotas,
                moveProvisionSupported, allocatedSupported, aggregationSettings, aggregationAlgorithm, uiSettings,
                externalAccountUrlTemplates, multipleReservesAllowed);
    }

    @Override
    public String toString() {
        return ReflectionToStringBuilder.toString(this);
    }
}
