package ru.yandex.intranet.d.web.model.providers;

import java.util.List;
import java.util.Objects;
import java.util.Optional;

import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.v3.oas.annotations.media.Schema;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;

import ru.yandex.intranet.d.web.model.FeatureStateInputDto;

/**
 * Create provider DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Provider.")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ProviderCreateDto {

    private final String nameEn;
    private final String nameRu;
    private final String descriptionEn;
    private final String descriptionRu;
    private final String restApiUri;
    private final String grpcApiUri;
    private final Long sourceTvmId;
    private final Long destinationTvmId;
    private final Long abcServiceId;
    private final Boolean readOnly;
    private final Boolean multipleAccountsPerFolder;
    private final Boolean accountTransferWithQuota;
    private final Boolean managed;
    private final String key;
    private final Boolean accountsDisplayNameSupported;
    private final Boolean accountsKeySupported;
    private final Boolean accountsDeleteSupported;
    private final Boolean accountsSoftDeleteSupported;
    private final Boolean accountsMoveSupported;
    private final Boolean accountsRenameSupported;
    private final Boolean importAllowed;
    private final Boolean accountsSpacesSupported;
    private final Boolean perAccountVersionSupported;
    private final Boolean perProvisionVersionSupported;
    private final Boolean perAccountLastUpdateSupported;
    private final Boolean perProvisionLastUpdateSupported;
    private final Boolean operationIdDeduplicationSupported;
    private final Boolean syncCoolDownDisabled;
    private final Boolean retryCoolDownDisabled;
    private final Long accountsSyncPageSize;
    private final Boolean syncEnabled;
    private final Boolean grpcTlsOn;
    private final String meteringKey;
    private final Long trackerComponentId;
    private final Boolean moveProvisionSupported;
    private final FeatureStateInputDto allocatedSupported;
    private final @Nullable AggregationSettingsInputDto aggregationSettings;
    private final @Nullable AggregationAlgorithmInputDto aggregationAlgorithm;
    private final @Nullable ProviderUISettingsDto uiSettings;
    private final List<ExternalAccountUrlTemplateDto> externalAccountUrlTemplates;
    private final FeatureStateInputDto multipleReservesAllowed;

    @JsonCreator
    @SuppressWarnings("ParameterNumber")
    public ProviderCreateDto(String nameEn,
                             String nameRu,
                             String descriptionEn,
                             String descriptionRu,
                             String restApiUri,
                             String grpcApiUri,
                             Long sourceTvmId,
                             Long destinationTvmId,
                             Long abcServiceId,
                             Boolean readOnly,
                             Boolean multipleAccountsPerFolder,
                             Boolean accountTransferWithQuota,
                             Boolean managed,
                             String key,
                             Boolean accountsDisplayNameSupported,
                             Boolean accountsKeySupported,
                             Boolean accountsDeleteSupported,
                             Boolean accountsSoftDeleteSupported,
                             Boolean accountsMoveSupported,
                             Boolean accountsRenameSupported,
                             Boolean importAllowed,
                             Boolean accountsSpacesSupported,
                             Boolean perAccountVersionSupported,
                             Boolean perProvisionVersionSupported,
                             Boolean perAccountLastUpdateSupported,
                             Boolean perProvisionLastUpdateSupported,
                             Boolean operationIdDeduplicationSupported,
                             Boolean syncCoolDownDisabled,
                             Boolean retryCoolDownDisabled,
                             Long accountsSyncPageSize,
                             Boolean syncEnabled,
                             Boolean grpcTlsOn,
                             String meteringKey,
                             Long trackerComponentId,
                             Boolean moveProvisionSupported,
                             FeatureStateInputDto allocatedSupported,
                             @Nullable AggregationSettingsInputDto aggregationSettings,
                             @Nullable AggregationAlgorithmInputDto aggregationAlgorithm,
                             @Nullable ProviderUISettingsDto uiSettings,
                             List<ExternalAccountUrlTemplateDto> externalAccountUrlTemplates,
                             FeatureStateInputDto multipleReservesAllowed
    ) {
        this.nameEn = nameEn;
        this.nameRu = nameRu;
        this.descriptionEn = descriptionEn;
        this.descriptionRu = descriptionRu;
        this.restApiUri = restApiUri;
        this.grpcApiUri = grpcApiUri;
        this.sourceTvmId = sourceTvmId;
        this.destinationTvmId = destinationTvmId;
        this.abcServiceId = abcServiceId;
        this.readOnly = readOnly;
        this.multipleAccountsPerFolder = multipleAccountsPerFolder;
        this.accountTransferWithQuota = accountTransferWithQuota;
        this.managed = managed;
        this.key = key;
        this.accountsDisplayNameSupported = accountsDisplayNameSupported;
        this.accountsKeySupported = accountsKeySupported;
        this.accountsDeleteSupported = accountsDeleteSupported;
        this.accountsSoftDeleteSupported = accountsSoftDeleteSupported;
        this.accountsMoveSupported = accountsMoveSupported;
        this.accountsRenameSupported = accountsRenameSupported;
        this.importAllowed = importAllowed;
        this.accountsSpacesSupported = accountsSpacesSupported;
        this.perAccountVersionSupported = perAccountVersionSupported;
        this.perProvisionVersionSupported = perProvisionVersionSupported;
        this.perAccountLastUpdateSupported = perAccountLastUpdateSupported;
        this.perProvisionLastUpdateSupported = perProvisionLastUpdateSupported;
        this.operationIdDeduplicationSupported = operationIdDeduplicationSupported;
        this.syncCoolDownDisabled = syncCoolDownDisabled;
        this.retryCoolDownDisabled = retryCoolDownDisabled;
        this.accountsSyncPageSize = accountsSyncPageSize;
        this.syncEnabled = syncEnabled;
        this.grpcTlsOn = grpcTlsOn;
        this.meteringKey = meteringKey;
        this.trackerComponentId = trackerComponentId;
        this.moveProvisionSupported = moveProvisionSupported;
        this.allocatedSupported = allocatedSupported;
        this.aggregationSettings = aggregationSettings;
        this.aggregationAlgorithm = aggregationAlgorithm;
        this.uiSettings = uiSettings;
        this.externalAccountUrlTemplates = externalAccountUrlTemplates;
        this.multipleReservesAllowed = multipleReservesAllowed;
    }

    @Schema(description = "Name english.", required = true)
    public Optional<String> getNameEn() {
        return Optional.ofNullable(nameEn);
    }

    @Schema(description = "Name russian.", required = true)
    public Optional<String> getNameRu() {
        return Optional.ofNullable(nameRu);
    }

    @Schema(description = "Description english.", required = true)
    public Optional<String> getDescriptionEn() {
        return Optional.ofNullable(descriptionEn);
    }

    @Schema(description = "Description russian.", required = true)
    public Optional<String> getDescriptionRu() {
        return Optional.ofNullable(descriptionRu);
    }

    @Schema(description = "REST API URI.")
    public Optional<String> getRestApiUri() {
        return Optional.ofNullable(restApiUri);
    }

    @Schema(description = "GRPC API URI.")
    public Optional<String> getGrpcApiUri() {
        return Optional.ofNullable(grpcApiUri);
    }

    @Schema(description = "Source TVM id.")
    public Optional<Long> getSourceTvmId() {
        return Optional.ofNullable(sourceTvmId);
    }

    @Schema(description = "Destination TVM id.")
    public Optional<Long> getDestinationTvmId() {
        return Optional.ofNullable(destinationTvmId);
    }

    @Schema(description = "ABC service id.", required = true)
    public Optional<Long> getAbcServiceId() {
        return Optional.ofNullable(abcServiceId);
    }

    @Schema(description = "'Read only' flag.", required = true)
    public Optional<Boolean> getReadOnly() {
        return Optional.ofNullable(readOnly);
    }

    @Schema(description = "'Multiple accounts per folder' flag.", required = true)
    public Optional<Boolean> getMultipleAccountsPerFolder() {
        return Optional.ofNullable(multipleAccountsPerFolder);
    }

    @Schema(description = "'Account transfer with quota' flag.", required = true)
    public Optional<Boolean> getAccountTransferWithQuota() {
        return Optional.ofNullable(accountTransferWithQuota);
    }

    @Schema(description = "'Managed' flag.", required = true)
    public Optional<Boolean> getManaged() {
        return Optional.ofNullable(managed);
    }

    @Schema(description = "Unique key.", required = true)
    public Optional<String> getKey() {
        return Optional.ofNullable(key);
    }

    @Schema(description = "'Account display name is supported' flag.", required = true)
    public Optional<Boolean> getAccountsDisplayNameSupported() {
        return Optional.ofNullable(accountsDisplayNameSupported);
    }

    @Schema(description = "'Account key is supported' flag.", required = true)
    public Optional<Boolean> getAccountsKeySupported() {
        return Optional.ofNullable(accountsKeySupported);
    }

    @Schema(description = "'Account deletion is supported' flag.", required = true)
    public Optional<Boolean> getAccountsDeleteSupported() {
        return Optional.ofNullable(accountsDeleteSupported);
    }

    @Schema(description = "'Account soft-delete is supported' flag.", required = true)
    public Optional<Boolean> getAccountsSoftDeleteSupported() {
        return Optional.ofNullable(accountsSoftDeleteSupported);
    }

    @Schema(description = "'Account folder update is supported' flag.", required = true)
    public Optional<Boolean> getAccountsMoveSupported() {
        return Optional.ofNullable(accountsMoveSupported);
    }

    @Schema(description = "'Account rename is supported' flag.", required = true)
    public Optional<Boolean> getAccountsRenameSupported() {
        return Optional.ofNullable(accountsRenameSupported);
    }

    @Schema(description = "'Import is allowed' flag.", required = true)
    public Optional<Boolean> getImportAllowed() {
        return Optional.ofNullable(importAllowed);
    }

    @Schema(description = "'Accounts spaces are supported' flag", required = true)
    public Optional<Boolean> getAccountsSpacesSupported() {
        return Optional.ofNullable(accountsSpacesSupported);
    }

    @Schema(description = "'Per account version is supported' flag", required = true)
    public Optional<Boolean> getPerAccountVersionSupported() {
        return Optional.ofNullable(perAccountVersionSupported);
    }

    @Schema(description = "'Per provision version is supported' flag", required = true)
    public Optional<Boolean> getPerProvisionVersionSupported() {
        return Optional.ofNullable(perProvisionVersionSupported);
    }

    @Schema(description = "'Per account last update is supported' flag", required = true)
    public Optional<Boolean> getPerAccountLastUpdateSupported() {
        return Optional.ofNullable(perAccountLastUpdateSupported);
    }

    @Schema(description = "'Per provision last update is supported' flag", required = true)
    public Optional<Boolean> getPerProvisionLastUpdateSupported() {
        return Optional.ofNullable(perProvisionLastUpdateSupported);
    }

    @Schema(description = "'Operation id deduplication is supported' flag", required = true)
    public Optional<Boolean> getOperationIdDeduplicationSupported() {
        return Optional.ofNullable(operationIdDeduplicationSupported);
    }

    @Schema(description = "'Synchronization cool down is disabled' flag", required = true)
    public Optional<Boolean> getSyncCoolDownDisabled() {
        return Optional.ofNullable(syncCoolDownDisabled);
    }

    @Schema(description = "'Retries cool down is disabled' flag", required = true)
    public Optional<Boolean> getRetryCoolDownDisabled() {
        return Optional.ofNullable(retryCoolDownDisabled);
    }

    @Schema(description = "'Sync is enabled' flag", required = true)
    public Optional<Boolean> getSyncEnabled() {
        return Optional.ofNullable(syncEnabled);
    }

    @Schema(description = "'Use tls in grpc' flag", required = true)
    public Optional<Boolean> getGrpcTlsOn() {
        return Optional.ofNullable(grpcTlsOn);
    }

    @Schema(description = "Provider key in Metering.")
    public Optional<String> getMeteringKey() {
        return Optional.ofNullable(meteringKey);
    }

    @Schema(description = "Provider component id in Tracker")
    public Optional<Long> getTrackerComponentId() {
        return Optional.ofNullable(trackerComponentId);
    }

    @Schema(description = "Maximum page size of accounts sync response.", required = true)
    public Optional<Long> getAccountsSyncPageSize() {
        return Optional.ofNullable(accountsSyncPageSize);
    }

    @Schema(description = "'MoveProvision method is supported' flag", required = true)
    public Optional<Boolean> getMoveProvisionSupported() {
        return Optional.ofNullable(moveProvisionSupported);
    }

    @Schema(description = "'Allocated supported' feature state")
    public Optional<FeatureStateInputDto> getAllocatedSupported() {
        return Optional.ofNullable(allocatedSupported);
    }

    @Schema(description = "Aggregation settings.")
    public Optional<AggregationSettingsInputDto> getAggregationSettings() {
        return Optional.ofNullable(aggregationSettings);
    }

    @Schema(description = "Aggregation algorithm.")
    public Optional<AggregationAlgorithmInputDto> getAggregationAlgorithm() {
        return Optional.ofNullable(aggregationAlgorithm);
    }

    @Schema(description = "Providers UI settings.")
    public Optional<ProviderUISettingsDto> getUiSettings() {
        return Optional.ofNullable(uiSettings);
    }

    @Schema(description = "External account url templates")
    public Optional<List<ExternalAccountUrlTemplateDto>> getExternalAccountUrlTemplates() {
        return Optional.ofNullable(externalAccountUrlTemplates);
    }

    @Schema(description = "'Multiple reserves allowed' feature state")
    public Optional<FeatureStateInputDto> getMultipleReservesAllowed() {
        return Optional.ofNullable(multipleReservesAllowed);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ProviderCreateDto that = (ProviderCreateDto) o;
        return Objects.equals(nameEn, that.nameEn) &&
                Objects.equals(nameRu, that.nameRu) &&
                Objects.equals(descriptionEn, that.descriptionEn) &&
                Objects.equals(descriptionRu, that.descriptionRu) &&
                Objects.equals(restApiUri, that.restApiUri) &&
                Objects.equals(grpcApiUri, that.grpcApiUri) &&
                Objects.equals(sourceTvmId, that.sourceTvmId) &&
                Objects.equals(destinationTvmId, that.destinationTvmId) &&
                Objects.equals(abcServiceId, that.abcServiceId) &&
                Objects.equals(readOnly, that.readOnly) &&
                Objects.equals(multipleAccountsPerFolder, that.multipleAccountsPerFolder) &&
                Objects.equals(accountTransferWithQuota, that.accountTransferWithQuota) &&
                Objects.equals(managed, that.managed) &&
                Objects.equals(key, that.key) &&
                Objects.equals(accountsDisplayNameSupported, that.accountsDisplayNameSupported) &&
                Objects.equals(accountsKeySupported, that.accountsKeySupported) &&
                Objects.equals(accountsDeleteSupported, that.accountsDeleteSupported) &&
                Objects.equals(accountsSoftDeleteSupported, that.accountsSoftDeleteSupported) &&
                Objects.equals(accountsMoveSupported, that.accountsMoveSupported) &&
                Objects.equals(accountsRenameSupported, that.accountsRenameSupported) &&
                Objects.equals(importAllowed, that.importAllowed) &&
                Objects.equals(accountsSpacesSupported, that.accountsSpacesSupported) &&
                Objects.equals(perAccountVersionSupported, that.perAccountVersionSupported) &&
                Objects.equals(perProvisionVersionSupported, that.perProvisionVersionSupported) &&
                Objects.equals(perAccountLastUpdateSupported, that.perAccountLastUpdateSupported) &&
                Objects.equals(perProvisionLastUpdateSupported, that.perProvisionLastUpdateSupported) &&
                Objects.equals(operationIdDeduplicationSupported, that.operationIdDeduplicationSupported) &&
                Objects.equals(syncCoolDownDisabled, that.syncCoolDownDisabled) &&
                Objects.equals(retryCoolDownDisabled, that.retryCoolDownDisabled) &&
                Objects.equals(syncEnabled, that.syncEnabled) &&
                Objects.equals(grpcTlsOn, that.grpcTlsOn) &&
                Objects.equals(meteringKey, that.meteringKey) &&
                Objects.equals(trackerComponentId, that.trackerComponentId) &&
                Objects.equals(accountsSyncPageSize, that.accountsSyncPageSize) &&
                Objects.equals(moveProvisionSupported, that.moveProvisionSupported) &&
                Objects.equals(allocatedSupported, that.allocatedSupported) &&
                Objects.equals(aggregationSettings, that.aggregationSettings) &&
                Objects.equals(aggregationAlgorithm, that.aggregationAlgorithm) &&
                Objects.equals(uiSettings, that.uiSettings) &&
                Objects.equals(externalAccountUrlTemplates, that.externalAccountUrlTemplates) &&
                Objects.equals(multipleReservesAllowed, that.multipleReservesAllowed);
    }

    @Override
    public int hashCode() {
        return Objects.hash(nameEn, nameRu, descriptionEn, descriptionRu, restApiUri, grpcApiUri, sourceTvmId,
                destinationTvmId, abcServiceId, readOnly, multipleAccountsPerFolder, accountTransferWithQuota,
                managed, key, accountsDisplayNameSupported, accountsKeySupported, accountsDeleteSupported,
                accountsSoftDeleteSupported, accountsMoveSupported, accountsRenameSupported, importAllowed,
                accountsSpacesSupported, perAccountVersionSupported, perProvisionVersionSupported,
                perAccountLastUpdateSupported, perProvisionLastUpdateSupported, operationIdDeduplicationSupported,
                syncCoolDownDisabled, retryCoolDownDisabled, syncEnabled, grpcTlsOn, meteringKey, trackerComponentId,
                accountsSyncPageSize, moveProvisionSupported, allocatedSupported, aggregationSettings,
                aggregationAlgorithm, uiSettings, externalAccountUrlTemplates, multipleReservesAllowed);
    }

    @Override
    public String toString() {
        return ReflectionToStringBuilder.toString(this);
    }
}
