package ru.yandex.intranet.d.web.model.providers;

import java.util.Objects;
import java.util.Optional;

import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.v3.oas.annotations.media.Schema;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;

/**
 * Provider DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Provider.")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ProviderDto {

    private final String id;
    private final long version;
    private final String name;
    private final String description;
    private final long abcServiceId;
    private final boolean readOnly;
    private final boolean managed;
    private final String key;
    private final @Nullable ProviderUISettingsDto uiSettings;

    @JsonCreator
    @SuppressWarnings("ParameterNumber")
    public ProviderDto(
            String id,
            long version,
            String name,
            String description,
            long abcServiceId,
            boolean readOnly,
            boolean managed,
            String key,
            @Nullable ProviderUISettingsDto uiSettings
    ) {
        this.id = id;
        this.version = version;
        this.name = name;
        this.description = description;
        this.abcServiceId = abcServiceId;
        this.readOnly = readOnly;
        this.managed = managed;
        this.key = key;
        this.uiSettings = uiSettings;
    }

    @Schema(description = "Unique id.", required = true)
    public String getId() {
        return id;
    }

    @Schema(description = "Provider version.", required = true)
    public long getVersion() {
        return version;
    }

    @Schema(description = "Name.", required = true)
    public String getName() {
        return name;
    }

    @Schema(description = "Description.", required = true)
    public String getDescription() {
        return description;
    }

    @Schema(description = "ABC service id.", required = true)
    public long getAbcServiceId() {
        return abcServiceId;
    }

    @Schema(description = "'Read only' flag.", required = true)
    public boolean isReadOnly() {
        return readOnly;
    }

    @Schema(description = "'Managed' flag.", required = true)
    public boolean isManaged() {
        return managed;
    }

    @Schema(description = "Unique key.", required = true)
    public String getKey() {
        return key;
    }

    @Schema(description = "Providers UI settings.")
    public Optional<ProviderUISettingsDto> getUiSettings() {
        return Optional.ofNullable(uiSettings);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ProviderDto that = (ProviderDto) o;
        return version == that.version &&
                abcServiceId == that.abcServiceId &&
                readOnly == that.readOnly &&
                managed == that.managed &&
                Objects.equals(id, that.id) &&
                Objects.equals(name, that.name) &&
                Objects.equals(description, that.description) &&
                Objects.equals(key, that.key) &&
                Objects.equals(uiSettings, that.uiSettings);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, version, name, description, abcServiceId, readOnly, managed, key,
                uiSettings);
    }

    @Override
    public String toString() {
        return ReflectionToStringBuilder.toString(this);
    }

}
