package ru.yandex.intranet.d.web.model.providers

import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import com.fasterxml.jackson.annotation.JsonInclude
import io.swagger.v3.oas.annotations.media.Schema

/**
 * ExternalAccountUrlTemplate dto.
 *
 * @author Evgenii Serov <evserov@yandex-team.ru>
 */
@Schema(description = "Dto with external account url template and provider version.")
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
data class ProviderExternalAccountUrlTemplateDto (
    val version: Long?,
    val externalAccountUrlTemplate: List<ExternalAccountUrlTemplateDto>?
) {
}
