package ru.yandex.intranet.d.web.model.providers;

import java.util.Objects;
import java.util.Set;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.v3.oas.annotations.media.Schema;

/**
 * Provider related resources settings DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Provider related resources settings.")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ProviderRelatedResourcesSettingsDto {

    private final Set<RelatedResourcesForResourceDto> relatedResourcesByResource;

    @JsonCreator
    public ProviderRelatedResourcesSettingsDto(Set<RelatedResourcesForResourceDto> relatedResourcesByResource) {
        this.relatedResourcesByResource = relatedResourcesByResource;
    }

    @Schema(description = "Related resources by resource.", required = true)
    public Set<RelatedResourcesForResourceDto> getRelatedResourcesByResource() {
        return relatedResourcesByResource;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ProviderRelatedResourcesSettingsDto that = (ProviderRelatedResourcesSettingsDto) o;
        return Objects.equals(relatedResourcesByResource, that.relatedResourcesByResource);
    }

    @Override
    public int hashCode() {
        return Objects.hash(relatedResourcesByResource);
    }

    @Override
    public String toString() {
        return "ProviderRelatedResourcesSettingsDto{" +
                "relatedResourcesByResource=" + relatedResourcesByResource +
                '}';
    }

}
