package ru.yandex.intranet.d.web.model.providers;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.v3.oas.annotations.media.Schema;

/**
 * Provider related resources settings response DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Provider related resources settings response.")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ProviderRelatedResourcesSettingsResponseDto {

    private final ProviderRelatedResourcesSettingsDto settings;
    private final long providerVersion;

    @JsonCreator
    public ProviderRelatedResourcesSettingsResponseDto(ProviderRelatedResourcesSettingsDto settings,
                                                       long providerVersion) {
        this.settings = settings;
        this.providerVersion = providerVersion;
    }

    @Schema(description = "Provider related resources settings.", required = true)
    public ProviderRelatedResourcesSettingsDto getSettings() {
        return settings;
    }

    @Schema(description = "Provider version.", required = true)
    public long getProviderVersion() {
        return providerVersion;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ProviderRelatedResourcesSettingsResponseDto that = (ProviderRelatedResourcesSettingsResponseDto) o;
        return providerVersion == that.providerVersion &&
                Objects.equals(settings, that.settings);
    }

    @Override
    public int hashCode() {
        return Objects.hash(settings, providerVersion);
    }

    @Override
    public String toString() {
        return "ProviderRelatedResourcesSettingsResponseDto{" +
                "settings=" + settings +
                ", providerVersion=" + providerVersion +
                '}';
    }

}
