package ru.yandex.intranet.d.web.model.providers

import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import io.swagger.v3.oas.annotations.media.Schema

/**
 * Provider reserve account DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Provider reserve account.")
@JsonIgnoreProperties(ignoreUnknown = true)
data class ProviderReserveAccountDto(
    @get:Schema(description = "Account id.", required = true)
    val accountId: String,
    @get:Schema(description = "Accounts space id.")
    val accountsSpaceId: String?
)
