package ru.yandex.intranet.d.web.model.providers;

import java.time.Instant;
import java.util.Map;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.v3.oas.annotations.media.Schema;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;

/**
 * ProviderSyncErrorDto.
 *
 * @author Vladimir Zaytsev <vzay@yandex-team.ru>
 * @since 23-06-2021
 */
@Schema(description = "Provider sync error.")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ProviderSyncErrorDto {
    private final Instant requestTimestamp;
    private final String errorMessage;
    private final Map<String, String> errorDetails;

    @JsonCreator
    public ProviderSyncErrorDto(Instant requestTimestamp, String errorMessage, Map<String, String> errorDetails) {
        this.requestTimestamp = requestTimestamp;
        this.errorMessage = errorMessage;
        this.errorDetails = errorDetails;
    }

    @Schema(description = "Timestamp of request to provider, in UTC.", required = false)
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", timezone = "UTC")
    public Instant getRequestTimestamp() {
        return requestTimestamp;
    }

    @Schema(description = "Last sync error message.", required = false)
    public String getErrorMessage() {
        return errorMessage;
    }

    @Schema(description = "Last sync error details.", required = false)
    public Map<String, String> getErrorDetails() {
        return errorDetails;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ProviderSyncErrorDto that = (ProviderSyncErrorDto) o;
        return Objects.equals(requestTimestamp, that.requestTimestamp) &&
                Objects.equals(errorMessage, that.errorMessage) &&
                Objects.equals(errorDetails, that.errorDetails);
    }

    @Override
    public int hashCode() {
        return Objects.hash(requestTimestamp, errorMessage, errorDetails);
    }

    @Override
    public String toString() {
        return ReflectionToStringBuilder.toString(this);
    }
}
