package ru.yandex.intranet.d.web.model.providers

import com.fasterxml.jackson.annotation.JsonIgnore
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import com.fasterxml.jackson.annotation.JsonInclude
import io.swagger.v3.oas.annotations.media.Schema
import ru.yandex.intranet.d.model.providers.ProviderUISettings
import ru.yandex.intranet.d.web.model.MultilingualGrammaticalFormsDto

/**
 * ProviderUISettingsDto.
 *
 * @author Vladimir Zaytsev <vzay@yandex-team.ru>
 * @since 10-03-2022
 */
@Schema(description = "Aggregation algorithm.")
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
data class ProviderUISettingsDto(
    val titleForTheAccount: MultilingualGrammaticalFormsDto?,
) {
    constructor(model: ProviderUISettings) : this(
        model.titleForTheAccount?.let { MultilingualGrammaticalFormsDto(it) }
    )

    constructor(proto: ru.yandex.intranet.d.backend.service.proto.ProviderUISettings) : this(
        proto.titleForTheAccount?.let { MultilingualGrammaticalFormsDto(it) }
    )

    @JsonIgnore
    fun toModel(): ProviderUISettings {
        return ProviderUISettings(titleForTheAccount?.toModel())
    }
}
