package ru.yandex.intranet.d.web.model.providers;

import java.util.List;
import java.util.Objects;
import java.util.Optional;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.v3.oas.annotations.media.Schema;

/**
 * Put provider related resources settings DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Put provider related resources settings.")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class PutProviderRelatedResourcesSettingsDto {

    private final List<PutRelatedResourcesForResourceDto> relatedResourcesByResource;

    @JsonCreator
    public PutProviderRelatedResourcesSettingsDto(List<PutRelatedResourcesForResourceDto> relatedResourcesByResource) {
        this.relatedResourcesByResource = relatedResourcesByResource;
    }

    @Schema(description = "Related resources by resource.", required = true)
    public Optional<List<PutRelatedResourcesForResourceDto>> getRelatedResourcesByResource() {
        return Optional.ofNullable(relatedResourcesByResource);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        PutProviderRelatedResourcesSettingsDto that = (PutProviderRelatedResourcesSettingsDto) o;
        return Objects.equals(relatedResourcesByResource, that.relatedResourcesByResource);
    }

    @Override
    public int hashCode() {
        return Objects.hash(relatedResourcesByResource);
    }

    @Override
    public String toString() {
        return "PutProviderRelatedResourcesSettingsDto{" +
                "relatedResourcesByResource=" + relatedResourcesByResource +
                '}';
    }

}
