package ru.yandex.intranet.d.web.model.providers;

import java.util.Objects;
import java.util.Optional;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.v3.oas.annotations.media.Schema;

/**
 * Put provider related resources settings request DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Put provider related resources settings request.")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class PutProviderRelatedResourcesSettingsRequestDto {

    private final PutProviderRelatedResourcesSettingsDto settings;
    private final Long providerVersion;

    @JsonCreator
    public PutProviderRelatedResourcesSettingsRequestDto(PutProviderRelatedResourcesSettingsDto settings,
                                                         Long providerVersion) {
        this.settings = settings;
        this.providerVersion = providerVersion;
    }

    @Schema(description = "Provider related resources settings.", required = true)
    public Optional<PutProviderRelatedResourcesSettingsDto> getSettings() {
        return Optional.ofNullable(settings);
    }

    @Schema(description = "Provider version.", required = true)
    public Optional<Long> getProviderVersion() {
        return Optional.ofNullable(providerVersion);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        PutProviderRelatedResourcesSettingsRequestDto that = (PutProviderRelatedResourcesSettingsRequestDto) o;
        return Objects.equals(settings, that.settings) &&
                Objects.equals(providerVersion, that.providerVersion);
    }

    @Override
    public int hashCode() {
        return Objects.hash(settings, providerVersion);
    }

    @Override
    public String toString() {
        return "PutProviderRelatedResourcesSettingsRequestDto{" +
                "settings=" + settings +
                ", providerVersion=" + providerVersion +
                '}';
    }

}
