package ru.yandex.intranet.d.web.model.providers;

import java.util.Objects;
import java.util.Optional;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.v3.oas.annotations.media.Schema;

/**
 * Put related resource DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Put related resource.")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class PutRelatedResourceDto {

    private final String resourceId;
    private final Long numerator;
    private final Long denominator;

    @JsonCreator
    public PutRelatedResourceDto(String resourceId, Long numerator, Long denominator) {
        this.resourceId = resourceId;
        this.numerator = numerator;
        this.denominator = denominator;
    }

    @Schema(description = "Resource id.", required = true)
    public Optional<String> getResourceId() {
        return Optional.ofNullable(resourceId);
    }

    @Schema(description = "Numerator.", required = true)
    public Optional<Long> getNumerator() {
        return Optional.ofNullable(numerator);
    }

    @Schema(description = "Denominator.", required = true)
    public Optional<Long> getDenominator() {
        return Optional.ofNullable(denominator);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        PutRelatedResourceDto that = (PutRelatedResourceDto) o;
        return Objects.equals(resourceId, that.resourceId) &&
                Objects.equals(numerator, that.numerator) &&
                Objects.equals(denominator, that.denominator);
    }

    @Override
    public int hashCode() {
        return Objects.hash(resourceId, numerator, denominator);
    }

    @Override
    public String toString() {
        return "PutRelatedResourceDto{" +
                "resourceId='" + resourceId + '\'' +
                ", numerator=" + numerator +
                ", denominator=" + denominator +
                '}';
    }

}
