package ru.yandex.intranet.d.web.model.providers;

import java.util.List;
import java.util.Objects;
import java.util.Optional;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.v3.oas.annotations.media.Schema;

/**
 * Put related resources for resource DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Put related resources for resource.")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class PutRelatedResourcesForResourceDto {

    private final String resourceId;
    private final List<PutRelatedResourceDto> relatedResources;

    @JsonCreator
    public PutRelatedResourcesForResourceDto(String resourceId, List<PutRelatedResourceDto> relatedResources) {
        this.resourceId = resourceId;
        this.relatedResources = relatedResources;
    }

    @Schema(description = "Resource id.", required = true)
    public Optional<String> getResourceId() {
        return Optional.ofNullable(resourceId);
    }

    @Schema(description = "Related resources.", required = true)
    public Optional<List<PutRelatedResourceDto>> getRelatedResources() {
        return Optional.ofNullable(relatedResources);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        PutRelatedResourcesForResourceDto that = (PutRelatedResourcesForResourceDto) o;
        return Objects.equals(resourceId, that.resourceId) &&
                Objects.equals(relatedResources, that.relatedResources);
    }

    @Override
    public int hashCode() {
        return Objects.hash(resourceId, relatedResources);
    }

    @Override
    public String toString() {
        return "PutRelatedResourcesForResourceDto{" +
                "resourceId='" + resourceId + '\'' +
                ", relatedResources=" + relatedResources +
                '}';
    }

}
