package ru.yandex.intranet.d.web.model.providers;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.v3.oas.annotations.media.Schema;

import ru.yandex.intranet.d.model.providers.RelatedCoefficient;

/**
 * Related resource coefficient DTO.
 *
 * @author Ruslan Kadriev <aqru@yandex-team.ru>
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public final class RelatedCoefficientDto {
    private final long numerator;
    private final long denominator;

    @JsonCreator
    public RelatedCoefficientDto(long numerator, long denominator) {
        this.numerator = numerator;
        this.denominator = denominator;
    }

    @Schema(description = "Numerator of coefficient.", required = true)
    public long getNumerator() {
        return numerator;
    }

    @Schema(description = "Denominator of coefficient.", required = true)
    public long getDenominator() {
        return denominator;
    }

    @Override
    public boolean equals(Object o) {

        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        RelatedCoefficientDto that = (RelatedCoefficientDto) o;
        return numerator == that.numerator &&
                denominator == that.denominator;
    }

    @Override
    public int hashCode() {
        return Objects.hash(numerator, denominator);
    }

    @Override
    public String toString() {
        return "RelatedCoefficientDto{" +
                "numerator=" + numerator +
                ", denominator=" + denominator +
                '}';
    }

    public static RelatedCoefficientDto fromRelatedCoefficient(RelatedCoefficient relatedCoefficient) {
        return new RelatedCoefficientDto(relatedCoefficient.getNumerator(), relatedCoefficient.getDenominator());
    }
}
