package ru.yandex.intranet.d.web.model.providers;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.v3.oas.annotations.media.Schema;

/**
 * Related resource DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Related resource.")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class RelatedResourceDto {

    private final String resourceId;
    private final long numerator;
    private final long denominator;

    @JsonCreator
    public RelatedResourceDto(String resourceId, long numerator, long denominator) {
        this.resourceId = resourceId;
        this.numerator = numerator;
        this.denominator = denominator;
    }

    @Schema(description = "Resource id.", required = true)
    public String getResourceId() {
        return resourceId;
    }

    @Schema(description = "Numerator.", required = true)
    public long getNumerator() {
        return numerator;
    }

    @Schema(description = "Denominator.", required = true)
    public long getDenominator() {
        return denominator;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        RelatedResourceDto that = (RelatedResourceDto) o;
        return numerator == that.numerator &&
                denominator == that.denominator &&
                Objects.equals(resourceId, that.resourceId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(resourceId, numerator, denominator);
    }

    @Override
    public String toString() {
        return "RelatedResourceDto{" +
                "resourceId='" + resourceId + '\'' +
                ", numerator=" + numerator +
                ", denominator=" + denominator +
                '}';
    }

}
