package ru.yandex.intranet.d.web.model.providers;

import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.v3.oas.annotations.media.Schema;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuples;

import ru.yandex.intranet.d.model.providers.RelatedResourceMapping;

/**
 * Resource mapping to related resources DTO.
 *
 * @author Ruslan Kadriev <aqru@yandex-team.ru>
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public final class RelatedResourceMappingDto {
    private final Map<String, RelatedCoefficientDto> relatedCoefficientMap;

    @JsonCreator
    public RelatedResourceMappingDto(Map<String, RelatedCoefficientDto> relatedCoefficientMap) {
        this.relatedCoefficientMap = relatedCoefficientMap;
    }

    @Schema(description = "Relative resource coefficient map.", required = true)
    public Map<String, RelatedCoefficientDto> getRelatedCoefficientMap() {
        return relatedCoefficientMap;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        RelatedResourceMappingDto that = (RelatedResourceMappingDto) o;
        return Objects.equals(relatedCoefficientMap, that.relatedCoefficientMap);
    }

    @Override
    public int hashCode() {
        return Objects.hash(relatedCoefficientMap);
    }

    @Override
    public String toString() {
        return "RelatedResourceMappingDto{" +
                "relatedCoefficientMap=" + relatedCoefficientMap +
                '}';
    }

    public static RelatedResourceMappingDto fromRelatedResourceMapping(RelatedResourceMapping relatedResourceMapping) {
        return new RelatedResourceMappingDto(relatedResourceMapping.getRelatedCoefficientMap().entrySet().stream()
                .map(e -> Tuples.of(e.getKey(), RelatedCoefficientDto.fromRelatedCoefficient(e.getValue())))
                .collect(Collectors.toMap(Tuple2::getT1, Tuple2::getT2)));
    }
}
