package ru.yandex.intranet.d.web.model.providers;

import java.util.Objects;
import java.util.Set;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.v3.oas.annotations.media.Schema;

/**
 * Related resources for resource DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Related resources for resource.")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class RelatedResourcesForResourceDto {

    private final String resourceId;
    private final Set<RelatedResourceDto> relatedResources;

    @JsonCreator
    public RelatedResourcesForResourceDto(String resourceId, Set<RelatedResourceDto> relatedResources) {
        this.resourceId = resourceId;
        this.relatedResources = relatedResources;
    }

    @Schema(description = "Resource id.", required = true)
    public String getResourceId() {
        return resourceId;
    }

    @Schema(description = "Related resources.", required = true)
    public Set<RelatedResourceDto> getRelatedResources() {
        return relatedResources;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        RelatedResourcesForResourceDto that = (RelatedResourcesForResourceDto) o;
        return Objects.equals(resourceId, that.resourceId) &&
                Objects.equals(relatedResources, that.relatedResources);
    }

    @Override
    public int hashCode() {
        return Objects.hash(resourceId, relatedResources);
    }

    @Override
    public String toString() {
        return "RelatedResourcesForResourceDto{" +
                "resourceId='" + resourceId + '\'' +
                ", relatedResources=" + relatedResources +
                '}';
    }

}
