package ru.yandex.intranet.d.web.model.providers

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonValue
import io.swagger.v3.oas.annotations.media.Schema

/**
 * Usage mode DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Usage mode.")
enum class UsageModeDto {
    UNDEFINED,
    TIME_SERIES,
    UNUSED_ESTIMATION_VALUE;

    @JsonValue
    fun toJsonValue(): String {
        return name
    }

    companion object {
        @JsonCreator
        @JvmStatic
        fun fromJsonValue(value: String?): UsageModeDto? {
            if (value == null) {
                return null
            }
            return valueOf(value)
        }
    }

}
