package ru.yandex.intranet.d.web.model.provisions

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import io.swagger.v3.oas.annotations.media.Schema

/**
 * Provider reserve provision response value DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Provider reserve provision value.")
@JsonIgnoreProperties(ignoreUnknown = true)
data class ProviderReserveProvisionResponseValueDto @JsonCreator constructor(
    @get:Schema(description = "Resource id.", required = true)
    val resourceId: String,
    @get:Schema(description = "Provided amount.", required = true)
    val provided: Long,
    @get:Schema(description = "Provided amount unit key.", required = true)
    val providedUnitKey: String
)
