package ru.yandex.intranet.d.web.model.provisions

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import io.swagger.v3.oas.annotations.media.Schema

/**
 * Update provider reserve provisions request DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Update provider reserve provisions request.")
@JsonIgnoreProperties(ignoreUnknown = true)
data class UpdateProviderReserveProvisionsRequestDto @JsonCreator constructor(
    @get:Schema(description = "Accounts space id.")
    val accountsSpaceId: String?,
    @get:Schema(description = "Provided amounts.", required = true)
    val values: List<ProviderReserveProvisionRequestValueDto?>?,
    @get:Schema(description = "If amounts are deltas or not.", required = true)
    val deltaValues: Boolean?
)
