package ru.yandex.intranet.d.web.model.provisions

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import io.swagger.v3.oas.annotations.media.Schema

/**
 * Update provider reserve provisions response DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Update provider reserve provisions response.")
@JsonIgnoreProperties(ignoreUnknown = true)
data class UpdateProviderReserveProvisionsResponseDto @JsonCreator constructor(
    @get:Schema(description = "Operation status.", required = true)
    val operationStatus: UpdateProviderReserveProvisionsStatusDto,
    @get:Schema(description = "Operation result.", required = true)
    val result: UpdateProviderReserveProvisionsResultDto?,
    @get:Schema(description = "Operation id.", required = true)
    val operationId: String
)
