package ru.yandex.intranet.d.web.model.provisions

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import io.swagger.v3.oas.annotations.media.Schema

/**
 * Update provider reserve provisions result DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Update provider reserve provisions result.")
@JsonIgnoreProperties(ignoreUnknown = true)
data class UpdateProviderReserveProvisionsResultDto @JsonCreator constructor(
    @get:Schema(description = "Account id.", required = true)
    val accountId: String,
    @get:Schema(description = "Provided amounts.", required = true)
    val values: List<ProviderReserveProvisionResponseValueDto>
)
