package ru.yandex.intranet.d.web.model.provisions

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonValue
import io.swagger.v3.oas.annotations.media.Schema

/**
 * Update provider reserve provisions status DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Update provider reserve provisions status.")
enum class UpdateProviderReserveProvisionsStatusDto {
    IN_PROGRESS,
    SUCCESS;

    @JsonValue
    fun toJsonValue(): String {
        return name
    }

    companion object {
        @JsonCreator
        @JvmStatic
        fun fromJsonValue(value: String?): UpdateProviderReserveProvisionsStatusDto? {
            if (value == null) {
                return null
            }
            return valueOf(value)
        }
    }
}
