package ru.yandex.intranet.d.web.model.provisions;

import java.util.Objects;
import java.util.Optional;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.v3.oas.annotations.media.Schema;

/**
 * Update provision DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Update provision request.")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class UpdateProvisionDto {

    private final String providerId;
    private final String resourceId;
    private final Long provided;
    private final String providedUnitKey;

    @JsonCreator
    public UpdateProvisionDto(String providerId, String resourceId, Long provided, String providedUnitKey) {
        this.providerId = providerId;
        this.resourceId = resourceId;
        this.provided = provided;
        this.providedUnitKey = providedUnitKey;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Schema(description = "Provider id.", required = true)
    public Optional<String> getProviderId() {
        return Optional.ofNullable(providerId);
    }

    @Schema(description = "Resource id.", required = true)
    public Optional<String> getResourceId() {
        return Optional.ofNullable(resourceId);
    }

    @Schema(description = "Provided amount.", required = true)
    public Optional<Long> getProvided() {
        return Optional.ofNullable(provided);
    }

    @Schema(description = "Provided amount unit key.", required = true)
    public Optional<String> getProvidedUnitKey() {
        return Optional.ofNullable(providedUnitKey);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UpdateProvisionDto that = (UpdateProvisionDto) o;
        return Objects.equals(providerId, that.providerId) &&
                Objects.equals(resourceId, that.resourceId) &&
                Objects.equals(provided, that.provided) &&
                Objects.equals(providedUnitKey, that.providedUnitKey);
    }

    @Override
    public int hashCode() {
        return Objects.hash(providerId, resourceId, provided, providedUnitKey);
    }

    @Override
    public String toString() {
        return "UpdateProvisionDto{" +
                "providerId='" + providerId + '\'' +
                ", resourceId='" + resourceId + '\'' +
                ", provided=" + provided +
                ", providedUnitKey='" + providedUnitKey + '\'' +
                '}';
    }

    public static final class Builder {

        private String providerId;
        private String resourceId;
        private Long provided;
        private String providedUnitKey;

        private Builder() {
        }

        public Builder providerId(String providerId) {
            this.providerId = providerId;
            return this;
        }

        public Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public Builder provided(Long provided) {
            this.provided = provided;
            return this;
        }

        public Builder providedUnitKey(String providedUnitKey) {
            this.providedUnitKey = providedUnitKey;
            return this;
        }

        public UpdateProvisionDto build() {
            return new UpdateProvisionDto(providerId, resourceId, provided, providedUnitKey);
        }

    }

}
