package ru.yandex.intranet.d.web.model.provisions;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;

/**
 * Update provision operation status DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Update provision operation status.")
public enum UpdateProvisionOperationStatusDto {

    IN_PROGRESS,
    SUCCESS;

    @JsonValue
    public String toJsonValue() {
        return name();
    }

    @JsonCreator
    public static UpdateProvisionOperationStatusDto fromJsonValue(String value) {
        return UpdateProvisionOperationStatusDto.valueOf(value);
    }

}
