package ru.yandex.intranet.d.web.model.provisions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.v3.oas.annotations.media.Schema;

/**
 * Update provisions request DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Update provisions request.")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class UpdateProvisionsDto {

    private final List<UpdateProvisionDto> updatedProvisions;

    @JsonCreator
    public UpdateProvisionsDto(List<UpdateProvisionDto> updatedProvisions) {
        this.updatedProvisions = updatedProvisions;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Schema(description = "Updated provisions.", required = true)
    public Optional<List<UpdateProvisionDto>> getUpdatedProvisions() {
        return Optional.ofNullable(updatedProvisions);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UpdateProvisionsDto that = (UpdateProvisionsDto) o;
        return Objects.equals(updatedProvisions, that.updatedProvisions);
    }

    @Override
    public int hashCode() {
        return Objects.hash(updatedProvisions);
    }

    @Override
    public String toString() {
        return "UpdateProvisionsDto{" +
                "updatedProvisions=" + updatedProvisions +
                '}';
    }

    public static final class Builder {

        private final List<UpdateProvisionDto> updatedProvisions = new ArrayList<>();

        private Builder() {
        }

        public Builder addProvision(UpdateProvisionDto provision) {
            this.updatedProvisions.add(provision);
            return this;
        }

        public Builder addProvisions(UpdateProvisionDto... provisions) {
            this.updatedProvisions.addAll(Arrays.asList(provisions));
            return this;
        }

        public Builder addProvisions(Collection<? extends UpdateProvisionDto> provisions) {
            this.updatedProvisions.addAll(provisions);
            return this;
        }

        public UpdateProvisionsDto build() {
            return new UpdateProvisionsDto(updatedProvisions);
        }

    }

}
