package ru.yandex.intranet.d.web.model.quotas;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.v3.oas.annotations.media.Schema;

import ru.yandex.intranet.d.model.accounts.AccountsQuotasOperationsModel;

@Schema(description = "Accounts quotas operations.")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class AccountsQuotasOperationsDto {
    private final String operationId;
    private final AccountsQuotasOperationsModel.RequestStatus requestStatus;

    @JsonCreator
    public AccountsQuotasOperationsDto(String operationId, AccountsQuotasOperationsModel.RequestStatus requestStatus) {
        this.operationId = operationId;
        this.requestStatus = requestStatus;
    }

    @Schema(description = "Operation id.", required = true)
    public String getOperationId() {
        return operationId;
    }

    @Schema(description = "Request status.", required = true)
    public AccountsQuotasOperationsModel.RequestStatus getRequestStatus() {
        return requestStatus;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AccountsQuotasOperationsDto that = (AccountsQuotasOperationsDto) o;
        return Objects.equals(operationId, that.operationId) &&
                requestStatus == that.requestStatus;
    }

    @Override
    public int hashCode() {
        return Objects.hash(operationId, requestStatus);
    }

    @Override
    public String toString() {
        return "AccountsQuotasOperationsDto{" +
                "operationId='" + operationId + '\'' +
                ", requestStatus=" + requestStatus +
                '}';
    }
}
