package ru.yandex.intranet.d.web.model.quotas

import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import io.swagger.v3.oas.annotations.media.Schema

/**
 * DTO contain count of cleared quotas and account quotas
 *
 * @author Evgenii Serov <evserov></evserov>@yandex-team.ru>
 */
@Schema(description = "Cleared quotas and account quotas.")
@JsonIgnoreProperties(ignoreUnknown = true)
data class ClearedQuotaDto(
    @get:Schema(description = "Count cleared quotas.")
    val countClearedQuotas: Int? = null,

    @get:Schema(description = "Count cleared account quotas.")
    val countClearedAccountQuotas: Int? = null,

    @get:Schema(description = "Started Job ID.")
    val jobId: String? = null,
) {
    constructor(countClearedQuotas: Int, countClearedAccountQuotas: Int): this(
        countClearedQuotas = countClearedQuotas,
        countClearedAccountQuotas = countClearedAccountQuotas,
        jobId = null
    )

    constructor(jobId: String?) : this(
        countClearedQuotas = null,
        countClearedAccountQuotas = null,
        jobId = jobId
    )
}
