package ru.yandex.intranet.d.web.model.quotas;

import java.math.BigDecimal;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.v3.oas.annotations.media.Schema;

/**
 * Folder quota DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Folder quota.")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class FolderQuotaDto {

    private final String resourceId;
    private final BigDecimal quota;
    private final String quotaUnitKey;
    private final BigDecimal balance;
    private final String balanceUnitKey;
    private final String providerId;

    @JsonCreator
    public FolderQuotaDto(String resourceId,
                          BigDecimal quota,
                          String quotaUnitKey,
                          BigDecimal balance,
                          String balanceUnitKey,
                          String providerId) {
        this.resourceId = resourceId;
        this.quota = quota;
        this.quotaUnitKey = quotaUnitKey;
        this.balance = balance;
        this.balanceUnitKey = balanceUnitKey;
        this.providerId = providerId;
    }

    @Schema(description = "Resource id.", required = true)
    public String getResourceId() {
        return resourceId;
    }

    @Schema(description = "Quota value.", required = true)
    public BigDecimal getQuota() {
        return quota;
    }

    @Schema(description = "Unit of measurement key for quota value.", required = true)
    public String getQuotaUnitKey() {
        return quotaUnitKey;
    }

    @Schema(description = "Balance value.", required = true)
    public BigDecimal getBalance() {
        return balance;
    }

    @Schema(description = "Unit of measurement key for balance value.", required = true)
    public String getBalanceUnitKey() {
        return balanceUnitKey;
    }

    @Schema(description = "Provider id.", required = true)
    public String getProviderId() {
        return providerId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        FolderQuotaDto that = (FolderQuotaDto) o;
        return Objects.equals(resourceId, that.resourceId) &&
                Objects.equals(quota, that.quota) &&
                Objects.equals(quotaUnitKey, that.quotaUnitKey) &&
                Objects.equals(balance, that.balance) &&
                Objects.equals(balanceUnitKey, that.balanceUnitKey) &&
                Objects.equals(providerId, that.providerId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(resourceId, quota, quotaUnitKey, balance, balanceUnitKey, providerId);
    }

    @Override
    public String toString() {
        return "FolderQuotaDto{" +
                "resourceId='" + resourceId + '\'' +
                ", quota=" + quota +
                ", quotaUnitKey='" + quotaUnitKey + '\'' +
                ", balance=" + balance +
                ", balanceUnitKey='" + balanceUnitKey + '\'' +
                ", providerId='" + providerId + '\'' +
                '}';
    }

}
