package ru.yandex.intranet.d.web.model.quotas;

import java.math.BigDecimal;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;

/**
 * Folder resource quota DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Folder resource quota.")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class FolderResourceQuotaDto {

    private final BigDecimal quota;
    private final String quotaUnitKey;
    private final BigDecimal balance;
    private final String balanceUnitKey;

    @JsonCreator
    public FolderResourceQuotaDto(@JsonProperty("quota") BigDecimal quota,
                                  @JsonProperty("quotaUnitKey") String quotaUnitKey,
                                  @JsonProperty("balance") BigDecimal balance,
                                  @JsonProperty("balanceUnitKey") String balanceUnitKey) {
        this.quota = quota;
        this.quotaUnitKey = quotaUnitKey;
        this.balance = balance;
        this.balanceUnitKey = balanceUnitKey;
    }

    @Schema(description = "Quota value.", required = true)
    public BigDecimal getQuota() {
        return quota;
    }

    @Schema(description = "Unit of measurement key for quota value.", required = true)
    public String getQuotaUnitKey() {
        return quotaUnitKey;
    }

    @Schema(description = "Balance value.", required = true)
    public BigDecimal getBalance() {
        return balance;
    }

    @Schema(description = "Unit of measurement key for balance value.", required = true)
    public String getBalanceUnitKey() {
        return balanceUnitKey;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        FolderResourceQuotaDto that = (FolderResourceQuotaDto) o;
        return Objects.equals(quota, that.quota) &&
                Objects.equals(quotaUnitKey, that.quotaUnitKey) &&
                Objects.equals(balance, that.balance) &&
                Objects.equals(balanceUnitKey, that.balanceUnitKey);
    }

    @Override
    public int hashCode() {
        return Objects.hash(quota, quotaUnitKey, balance, balanceUnitKey);
    }

    @Override
    public String toString() {
        return "FolderResourceQuotaDto{" +
                "quota=" + quota +
                ", quotaUnitKey='" + quotaUnitKey + '\'' +
                ", balance=" + balance +
                ", balanceUnitKey='" + balanceUnitKey + '\'' +
                '}';
    }

}
